@echo off
setlocal enabledelayedexpansion
cd /d "%~dp0"
title Marvel Rivals - Auto Launcher (Win 11 Edition)

:: ===============================================================
::  FORCE WINDOWS TERMINAL
:: ===============================================================
if "%WT_SESSION%"=="" (
    if exist "%LocalAppData%\Microsoft\WindowsApps\wt.exe" (
        start "" /b wt.exe -p "Command Prompt" -d "%~dp0." "%~0" %*
        exit /b
    )
)

:: ===============================================================
::  VISUAL SETUP (ANSI ESCAPE CODES)
:: ===============================================================
:: Define ESC char
for /F %%a in ('echo prompt $E ^| cmd') do set "ESC=%%a"

:: Colors
set "Reset=%ESC%[0m"
set "Bold=%ESC%[1m"
set "Dim=%ESC%[2m"
set "Red=%ESC%[31m"
set "Green=%ESC%[32m"
set "Yellow=%ESC%[33m"
set "Blue=%ESC%[34m"
set "Magenta=%ESC%[35m"
set "Cyan=%ESC%[36m"
set "White=%ESC%[37m"
set "BrightCyan=%ESC%[96m"
set "BrightGreen=%ESC%[92m"
set "BrightYellow=%ESC%[93m"

:: Backgrounds
set "BgRed=%ESC%[41m"
set "BgGreen=%ESC%[42m"
set "BgCyan=%ESC%[46m"

:: Symbols (ASCII-safe)
set "SymCheck=%Green%[ OK ]%Reset%"
set "SymInfo=%Cyan%[INFO]%Reset%"
set "SymWarn=%Yellow%[WARN]%Reset%"
set "SymErr=%Red%[FAIL]%Reset%"
set "SymWork=%Magenta%[****]%Reset%"
set "Arrow=%Cyan%==^>%Reset%"

:: Spinner frames (ASCII-safe)
set "Spin1=%Magenta%[   -]%Reset%"
set "Spin2=%Magenta%[  \ ]%Reset%"
set "Spin3=%Magenta%[ ^| ]%Reset%"
set "Spin4=%Magenta%[  / ]%Reset%"
set "Spin5=%Magenta%[   -]%Reset%"
set "Spin6=%Magenta%[  \ ]%Reset%"
set "Spin7=%Magenta%[ ^| ]%Reset%"
set "Spin8=%Magenta%[  / ]%Reset%"

:: ===============================================================
::  DISABLE QUICK EDIT MODE
:: ===============================================================
if "%1" neq "QuickEditDisabled" (
    powershell -Command "&{$p='[DllImport(\"kernel32.dll\")]public static extern bool SetConsoleMode(IntPtr h,uint m);[DllImport(\"kernel32.dll\")]public static extern bool GetConsoleMode(IntPtr h,out uint m);[DllImport(\"kernel32.dll\")]public static extern IntPtr GetStdHandle(int n);';$t=Add-Type -MemberDefinition $p -Name 'W' -PassThru;$h=$t::GetStdHandle(-10);$m=0;if($t::GetConsoleMode($h,[ref]$m)){$t::SetConsoleMode($h,$m -band -bnot 0x0040)}}" >nul 2>&1
)

:: ===============================================================
::  ANIMATED HEADER
:: ===============================================================
cls
echo.
call :PrintBorder "top"
echo.
call :TypewriterEffect "           MARVEL RIVALS OPTIMIZED LAUNCHER" 0
echo.
call :PrintBorder "bottom"
echo.
timeout /t 1 /nobreak >nul

:: ===============================================================
::  ADMINISTRATOR CHECK
:: ===============================================================
call :ShowProgress "Checking Permissions" "admin"
fltmc >nul 2>&1
if !errorLevel! neq 0 (
    echo.
    echo  %SymErr% %Bold%%Red%ACCESS DENIED%Reset%
    echo.
    echo  %Yellow%Administrator rights are required for optimization features.%Reset%
    echo  Please right-click this script and select:
    echo  %Bold%%BgRed% Run as Administrator %Reset%
    echo.
    call :PressAnyKey
    exit /b 1
)
echo  %SymCheck% %Green%Administrator Privileges Confirmed%Reset%
call :ShowSuccessBar 30
echo.

:: ===============================================================
::  SYSTEM INFORMATION
:: ===============================================================
echo  %Cyan%================================================================%Reset%
echo    %Bold%SYSTEM INFORMATION%Reset%
echo  %Cyan%================================================================%Reset%
echo.

:: Get RAM info
for /f "skip=1" %%p in ('wmic os get TotalVisibleMemorySize') do (
    set /a TotalRAM=%%p/1024
    goto :gotram
)
:gotram
echo  %SymInfo% Total RAM: %White%!TotalRAM! MB%Reset%

:: Get available RAM
for /f "skip=1" %%p in ('wmic os get FreePhysicalMemory') do (
    set /a FreeRAM=%%p/1024
    goto :gotfree
)
:gotfree
echo  %SymInfo% Available RAM: %White%!FreeRAM! MB%Reset%
set "InitialFreeRAM=!FreeRAM!"

:: Get OS info
for /f "tokens=2 delims==" %%I in ('wmic os get Caption /value') do set "OSName=%%I"
echo  %SymInfo% Operating System: %White%!OSName!%Reset%
echo.

:: ===============================================================
::  CONFIGURATION
:: ===============================================================
set "ConfigFile=config.ini"
set "FdExe=bin\fd.exe"
set "RamMap=bin\RAMMap64.exe"
set "GameLauncherName=MarvelRivals_Launcher.exe"

:: Initialize variables
set "PlatformPath="
set "GamePath="

:: ===============================================================
::  LOAD CONFIG
:: ===============================================================
if exist "%ConfigFile%" (
    call :ShowProgress "Loading Configuration" "config"
    for /f "usebackq tokens=1,* delims==" %%A in ("%ConfigFile%") do (
        if "%%A"=="PlatformPath" set "PlatformPath=%%B"
        if "%%A"=="GamePath" set "GamePath=%%B"
    )
    echo  %SymCheck% %Green%Configuration Loaded Successfully%Reset%
    echo.
)

:: Clean quotes if any
if defined PlatformPath set "PlatformPath=!PlatformPath:"=!"
if defined GamePath set "GamePath=!GamePath:"=!"

:: ===============================================================
::  PLATFORM SELECTION (If not in config)
:: ===============================================================
if defined PlatformPath (
    if exist "!PlatformPath!" goto :CheckGamePath
)

:SelectPlatform
cls
call :PrintHeader "SELECT LAUNCHER PLATFORM"
echo.
echo  %Arrow% %Cyan%[1]%Reset% %Bold%Steam%Reset%
echo     %Dim%The most popular PC gaming platform%Reset%
echo.
echo  %Arrow% %Cyan%[2]%Reset% %Bold%Epic Games%Reset%
echo     %Dim%Epic Games Launcher%Reset%
echo.
echo  %Arrow% %Cyan%[3]%Reset% %Bold%Loading Bay%Reset%
echo     %Dim%Direct launcher for Marvel Rivals%Reset%
echo.
echo  %Cyan%-----------------------------------------------------------------%Reset%
set /p "Choice= %Bold%Enter your choice (1-3):%Reset% "
echo  %Cyan%-----------------------------------------------------------------%Reset%

if "!Choice!"=="1" (
    set "LauncherName=steam.exe"
    set "DefaultLauncherPath=C:\Program Files ^(x86^)\Steam\steam.exe"
    set "LauncherLabel=Steam"
) else if "!Choice!"=="2" (
    set "LauncherName=EpicGamesLauncher.exe"
    set "DefaultLauncherPath=C:\Program Files ^(x86^)\Epic Games\Launcher\Portal\Binaries\Win64\EpicGamesLauncher.exe"
    set "LauncherLabel=Epic Games"
) else if "!Choice!"=="3" (
    set "LauncherName=LoadingBayLauncher.exe"
    set "DefaultLauncherPath=C:\Program Files\LoadingBay\LoadingBayLauncher.exe"
    set "LauncherLabel=Loading Bay"
) else (
    echo.
    echo  %SymErr% %Red%Invalid choice. Please select 1, 2, or 3.%Reset%
    timeout /t 2 /nobreak >nul
    goto :SelectPlatform
)

:SelectLauncherMethod
cls
call :PrintHeader "LAUNCHER PATH DETECTION"
echo.
echo  %SymInfo% Selected Platform: %Bold%!LauncherLabel!%Reset%
echo.
echo  %Arrow% %Cyan%[1]%Reset% %Bold%Auto-Search%Reset% %Dim%- Scan all drives%Reset%
echo     %Dim%Automatically search for the launcher%Reset%
echo.
echo  %Arrow% %Cyan%[2]%Reset% %Bold%Default Location%Reset%
echo     %Dim%!DefaultLauncherPath!%Reset%
echo.
echo  %Arrow% %Cyan%[3]%Reset% %Bold%Manual Input%Reset%
echo     %Dim%Enter the path manually%Reset%
echo.
echo  %Cyan%-----------------------------------------------------------------%Reset%
set /p "MethodChoice= %Bold%Enter your choice (1-3):%Reset% "
echo  %Cyan%-----------------------------------------------------------------%Reset%

if "!MethodChoice!"=="1" goto :AutoSearchLauncher
if "!MethodChoice!"=="2" (
    set "PlatformPath=!DefaultLauncherPath!"
    goto :ValidateLauncher
)
if "!MethodChoice!"=="3" goto :ManualLauncherInput
echo.
echo  %SymErr% %Red%Invalid choice%Reset%
timeout /t 1 /nobreak >nul
goto :SelectLauncherMethod

:AutoSearchLauncher
echo.
call :ShowProgress "Initializing Search Engine" "search"
echo  %SymCheck% %Green%Search engine ready%Reset%
echo.
echo  %SymWork% %Magenta%Scanning all drives for %Bold%!LauncherName!%Reset%%Magenta%...%Reset%
echo  %Dim%This may take 15-30 seconds depending on your system%Reset%
echo.

if exist "%FdExe%" (
    set "SearchDrives="
    for /f "skip=1 delims=" %%A in ('wmic logicaldisk where "DriveType=3" get DeviceID 2^>nul') do (
        for %%B in (%%A) do (
            echo  %Arrow% Scanning drive: %Cyan%%%B%Reset%
            set "SearchDrives=!SearchDrives! %%B\"
        )
    )
    if not defined SearchDrives set "SearchDrives=C:\"
    
    echo.
    call :ShowSpinner "Searching" 15
    
    pushd "bin"
    for /f "delims=" %%I in ('fd.exe -F -u --max-results 10 "!LauncherName!" !SearchDrives! 2^>nul') do (
        for %%F in ("%%I") do set "FoundFile=%%~nxF"
        if /I "!FoundFile!"=="!LauncherName!" (
            set "TempPath=%%I"
            echo !TempPath! | findstr /I /C:"\Prefetch\" >nul
            if errorlevel 1 (
                set "PlatformPath=%%I"
                goto :FoundLauncher
            )
        )
    )
    :FoundLauncher
    popd
)

if not defined PlatformPath (
    echo.
    echo  %SymErr% %Red%Could not find !LauncherName! automatically%Reset%
    echo.
    echo  %SymWarn% %Yellow%Possible reasons:%Reset%
    echo     %Dim%* Launcher not installed%Reset%
    echo     %Dim%* Non-standard installation path%Reset%
    echo     %Dim%* Insufficient search permissions%Reset%
    echo.
    echo  %SymInfo% Please try Manual Input option.
    echo.
    call :PressAnyKey
    goto :SelectLauncherMethod
)
echo.
echo  %SymCheck% %BrightGreen%Found launcher!%Reset%
echo  %Arrow% Location: %Green%!PlatformPath!%Reset%
call :ShowSuccessBar 50
timeout /t 2 /nobreak >nul
goto :ValidateLauncher

:ManualLauncherInput
cls
call :PrintHeader "MANUAL LAUNCHER PATH ENTRY"
echo.
echo  %SymInfo% %Bold%Example paths:%Reset%
echo.
if "!LauncherLabel!"=="Steam" (
    echo  %Dim%C:\Program Files ^(x86^)\Steam\steam.exe%Reset%
    echo  %Dim%D:\Steam\steam.exe%Reset%
) else if "!LauncherLabel!"=="Epic Games" (
    echo  %Dim%C:\Program Files ^(x86^)\Epic Games\Launcher\Portal\Binaries\Win64\EpicGamesLauncher.exe%Reset%
) else (
    echo  %Dim%C:\Program Files\LoadingBay\LoadingBayLauncher.exe%Reset%
)
echo.
echo  %Cyan%-----------------------------------------------------------------%Reset%
set /p "UserLauncherPath= %Bold%Enter full path to !LauncherName!:%Reset% "
echo  %Cyan%-----------------------------------------------------------------%Reset%

:: Remove quotes if user added them
set "UserLauncherPath=!UserLauncherPath:"=!"

set "PlatformPath=!UserLauncherPath!"
goto :ValidateLauncher

:ValidateLauncher
echo.
call :ShowProgress "Validating Launcher Path" "validate"
if not exist "!PlatformPath!" (
    echo  %SymErr% %Red%Launcher not found at specified location%Reset%
    echo.
    echo  %SymWarn% Path checked: %Dim%!PlatformPath!%Reset%
    echo.
    echo  %SymInfo% Please verify your installation or select another option.
    echo.
    call :PressAnyKey
    set "PlatformPath="
    goto :SelectPlatform
)
echo  %SymCheck% %Green%Launcher path validated successfully%Reset%
echo.

:: ===============================================================
::  GAME PATH SEARCH (If not in config)
:: ===============================================================
:CheckGamePath
if defined GamePath (
    if exist "!GamePath!" goto :SaveConfig
)

cls
call :PrintHeader "GAME PATH DETECTION METHOD"
echo.
echo  %Arrow% %Cyan%[1]%Reset% %Bold%Auto-Search%Reset% %Dim%- Scan all drives%Reset%
echo     %Dim%Automatically locate Marvel Rivals%Reset%
echo.
echo  %Arrow% %Cyan%[2]%Reset% %Bold%Manual Input%Reset%
echo     %Dim%Enter the game path manually%Reset%
echo.
echo  %Cyan%-----------------------------------------------------------------%Reset%
set /p "DiscChoice= %Bold%Enter your choice (1-2):%Reset% "
echo  %Cyan%-----------------------------------------------------------------%Reset%

if "!DiscChoice!"=="2" goto :ManualInput

:AutoSearch
echo.
call :ShowProgress "Initializing Game Search" "game"
echo  %SymCheck% %Green%Ready to search%Reset%
echo.
echo  %SymWork% %Magenta%Scanning all drives for %Bold%%GameLauncherName%%Reset%%Magenta%...%Reset%
echo  %Dim%This may take 20-40 seconds%Reset%
echo.

if exist "%FdExe%" (
    set "SearchDrives="
    for /f "skip=1 delims=" %%A in ('wmic logicaldisk where "DriveType=3" get DeviceID 2^>nul') do (
        for %%B in (%%A) do (
            echo  %Arrow% Scanning drive: %Cyan%%%B%Reset%
            set "SearchDrives=!SearchDrives! %%B\"
        )
    )
    if not defined SearchDrives set "SearchDrives=C:\"
    
    echo.
    call :ShowSpinner "Searching" 20
    
    pushd "bin"
    for /f "delims=" %%I in ('fd.exe -F -u --max-results 10 "%GameLauncherName%" !SearchDrives! 2^>nul') do (
        for %%F in ("%%I") do set "FoundFile=%%~nxF"
        if /I "!FoundFile!"=="%GameLauncherName%" (
            set "TempPath=%%I"
            echo !TempPath! | findstr /I /C:"\Prefetch\" >nul
            if errorlevel 1 (
                set "GamePath=%%I"
                goto :FoundGame
            )
        )
    )
    :FoundGame
    popd
)
goto :CheckFound

:ManualInput
cls
call :PrintHeader "MANUAL GAME PATH ENTRY"
echo.
echo  %SymInfo% %Bold%Example path:%Reset%
echo.
echo  %Dim%E:\Games\Steam\steamapps\common\MarvelRivals\MarvelRivals_Launcher.exe%Reset%
echo  %Dim%C:\Program Files\MarvelRivals\MarvelRivals_Launcher.exe%Reset%
echo.
echo  %SymWarn% %Yellow%Important:%Reset% %Dim%Must include the .exe filename%Reset%
echo.
echo  %Cyan%-----------------------------------------------------------------%Reset%
set /p "UserPath= %Bold%Enter full path:%Reset% "
echo  %Cyan%-----------------------------------------------------------------%Reset%

:: Remove quotes if user added them
set "UserPath=!UserPath:"=!"

echo.
call :ShowProgress "Validating Game Path" "validate"
if not exist "!UserPath!" (
    echo  %SymErr% %Red%File not found%Reset%
    echo.
    echo  %SymWarn% Path checked: %Dim%!UserPath!%Reset%
    echo  %SymInfo% Please ensure you entered the correct full path including .exe
    echo.
    call :PressAnyKey
    goto :ManualInput
)
echo  %SymCheck% %Green%Game path validated successfully%Reset%
echo.

set "GamePath=!UserPath!"
goto :SaveConfig

:CheckFound
if not defined GamePath (
    echo.
    echo  %SymErr% %Red%Could not find %GameLauncherName% automatically%Reset%
    echo.
    echo  %SymWarn% %Yellow%Possible reasons:%Reset%
    echo     %Dim%* Game not installed%Reset%
    echo     %Dim%* Non-standard installation location%Reset%
    echo     %Dim%* Game files moved or renamed%Reset%
    echo.
    echo  %SymInfo% Please ensure Marvel Rivals is installed and try again.
    echo.
    call :PressAnyKey
    exit /b 1
)
echo.
echo  %SymCheck% %BrightGreen%Game found!%Reset%
echo  %Arrow% Location: %Green%!GamePath!%Reset%
call :ShowSuccessBar 50
timeout /t 2 /nobreak >nul

:: ===============================================================
::  SAVE CONFIG
:: ===============================================================
:SaveConfig
echo.
call :ShowProgress "Saving Configuration" "save"
(
    echo PlatformPath=!PlatformPath!
    echo GamePath=!GamePath!
) > "%ConfigFile%"
echo  %SymCheck% %Green%Configuration saved to %Bold%config.ini%Reset%
echo.
timeout /t 1 /nobreak >nul

:: ===============================================================
::  RAM CLEANUP
:: ===============================================================
if exist "%RamMap%" (
    cls
    call :PrintHeader "MEMORY OPTIMIZATION"
    echo.
    echo  %SymInfo% Optimizing system memory for best gaming performance...
    echo.
    
    pushd "bin"
    
    set "OpCount=0"
    
    call :AnimatedOperation "Emptying Working Sets" "RAMMap64.exe -accepteula -ew"
    set /a OpCount+=1
    
    call :AnimatedOperation "Clearing System Working Sets" "RAMMap64.exe -accepteula -es"
    set /a OpCount+=1
    
    call :AnimatedOperation "Emptying Modified Page List" "RAMMap64.exe -accepteula -em"
    set /a OpCount+=1
    
    call :AnimatedOperation "Clearing Standby List" "RAMMap64.exe -accepteula -et"
    set /a OpCount+=1
    
    call :AnimatedOperation "Emptying Priority 0 Standby List" "RAMMap64.exe -accepteula -e0"
    set /a OpCount+=1
    
    popd
    
    echo.
    echo  %Cyan%================================================================%Reset%
    echo    %BrightGreen%SUCCESS - MEMORY OPTIMIZATION COMPLETE%Reset%
    echo  %Cyan%================================================================%Reset%
    echo.
    
    :: Show RAM improvement
    for /f "skip=1" %%p in ('wmic os get FreePhysicalMemory') do (
        set /a FinalFreeRAM=%%p/1024
        goto :gotfinal
    )
    :gotfinal
    set /a RAMFreed=!FinalFreeRAM!-!InitialFreeRAM!
    
    echo  %SymInfo% RAM Before: %White%!InitialFreeRAM! MB%Reset% available
    echo  %SymInfo% RAM After:  %BrightGreen%!FinalFreeRAM! MB%Reset% available
    if !RAMFreed! gtr 0 (
        echo  %SymCheck% %Green%Freed: %Bold%+!RAMFreed! MB%Reset%
    )
    echo.
    echo  %SymInfo% Completed %Bold%!OpCount!%Reset% optimization operations
    echo.
    timeout /t 3 /nobreak >nul
)

:: ===============================================================
::  LAUNCH SEQUENCE
:: ===============================================================
cls
call :PrintHeader "LAUNCH SEQUENCE"
echo.
echo  %Cyan%================================================================%Reset%
echo    %Bold%LAUNCH CONFIGURATION%Reset%
echo  %Cyan%================================================================%Reset%
echo.
echo  %SymInfo% Platform:
echo     %Dim%!PlatformPath!%Reset%
echo.
echo  %SymInfo% Game:
echo     %Dim%!GamePath!%Reset%
echo.

:: Countdown
echo  %Cyan%-----------------------------------------------------------------%Reset%
echo    %Bold%Starting in:%Reset%
echo  %Cyan%-----------------------------------------------------------------%Reset%
echo.

for /l %%i in (3,-1,1) do (
    <nul set /p "=%ESC%[1A%ESC%[2K  %Bold%%BrightGreen%%%i%Reset% seconds...%ESC%[0E"
    timeout /t 1 /nobreak >nul
)
<nul set /p "=%ESC%[1A%ESC%[2K  %BrightGreen%LAUNCHING%Reset%%ESC%[0E"
echo.
echo.

:: Launch Platform
call :ShowProgress "Launching Platform" "launch"
start "" "!PlatformPath!" >nul 2>&1
echo  %SymCheck% %Green%Platform launched successfully%Reset%

:: Wait for launcher to initialize
echo.
call :ShowProgress "Waiting for launcher initialization" "wait"
echo  %SymInfo% %Dim%Allowing launcher to fully start - 8 seconds...%Reset%
timeout /t 8 /nobreak >nul
echo  %SymCheck% %Green%Launcher initialized%Reset%

:: Launch Game
for %%I in ("!GamePath!") do set "GameDir=%%~dpI"

echo.
call :ShowProgress "Launching Marvel Rivals" "game"
echo  %SymInfo% %Dim%Starting game from: !GameDir!%Reset%
start "" /d "!GameDir!" "!GamePath!"
timeout /t 2 /nobreak >nul
echo  %SymCheck% %BrightGreen%Game launch command executed!%Reset%

:: Success animation
echo.
call :ShowSuccessBar 60
echo.

:: Final message
cls
call :PrintBorder "top"
echo.
echo                %BrightGreen%**  SUCCESS!  **%Reset%
echo.
echo          %Bold%%White%Marvel Rivals is now starting%Reset%
echo.
call :PrintBorder "bottom"
echo.
echo  %SymCheck% Platform: %Green%Running%Reset%
echo  %SymCheck% Game: %Green%Starting%Reset%
echo  %SymCheck% Optimization: %Green%Complete%Reset%
echo.
echo  %Cyan%-----------------------------------------------------------------%Reset%
echo    %Dim%Enjoy your game! This window will close automatically.%Reset%
echo  %Cyan%-----------------------------------------------------------------%Reset%
echo.

:: Closing countdown
for /l %%i in (5,-1,1) do (
    <nul set /p "=%ESC%[1A%ESC%[2K  %Dim%Closing in %%i seconds...%Reset%%ESC%[0E"
    timeout /t 1 /nobreak >nul
)

exit /b 0

:: ===============================================================
::  FUNCTIONS
:: ===============================================================

:PrintBorder
if "%~1"=="top" (
    echo  %Cyan%================================================================%Reset%
) else (
    echo  %Cyan%================================================================%Reset%
)
exit /b

:PrintHeader
echo.
echo  %Cyan%================================================================%Reset%
echo    %Bold%%White%%~1%Reset%
echo  %Cyan%================================================================%Reset%
exit /b

:TypewriterEffect
set "text=%~1"
set "delay=%~2"
if "%delay%"=="" set "delay=0"
set "line="
for /l %%i in (0,1,100) do (
    if defined text (
        set "char=!text:~0,1!"
        set "text=!text:~1!"
        set "line=!line!!char!"
        <nul set /p "=%ESC%[2K  %Bold%%White%!line!%Reset%%ESC%[0G"
        if %delay% gtr 0 timeout /t %delay% /nobreak >nul 2>&1
    )
)
echo.
exit /b

:ShowProgress
set "msg=%~1"
set "type=%~2"
echo  %SymWork% %Magenta%%msg%...%Reset%
if "%type%"=="admin" timeout /t 1 /nobreak >nul
if "%type%"=="config" (
    call :MiniSpinner 3
)
if "%type%"=="search" (
    call :MiniSpinner 2
)
if "%type%"=="validate" (
    call :MiniSpinner 2
)
if "%type%"=="game" (
    call :MiniSpinner 2
)
if "%type%"=="save" (
    call :MiniSpinner 1
)
if "%type%"=="launch" (
    call :MiniSpinner 2
)
if "%type%"=="wait" (
    timeout /t 1 /nobreak >nul
)
exit /b

:MiniSpinner
set "duration=%~1"
if "%duration%"=="" set "duration=3"
for /l %%i in (1,1,%duration%) do (
    <nul set /p "=%ESC%[1A%ESC%[2K  %Spin1% %Magenta%Processing...%Reset%%ESC%[0E"
    timeout /t 0 /nobreak >nul 2>&1
    <nul set /p "=%ESC%[1A%ESC%[2K  %Spin2% %Magenta%Processing...%Reset%%ESC%[0E"
    timeout /t 0 /nobreak >nul 2>&1
    <nul set /p "=%ESC%[1A%ESC%[2K  %Spin3% %Magenta%Processing...%Reset%%ESC%[0E"
    timeout /t 0 /nobreak >nul 2>&1
    <nul set /p "=%ESC%[1A%ESC%[2K  %Spin4% %Magenta%Processing...%Reset%%ESC%[0E"
    timeout /t 0 /nobreak >nul 2>&1
)
<nul set /p "=%ESC%[1A%ESC%[2K"
exit /b

:ShowSpinner
set "msg=%~1"
set "seconds=%~2"
if "%seconds%"=="" set "seconds=10"
set /a iterations=%seconds%*4

for /l %%i in (1,1,%iterations%) do (
    set /a frame=%%i%%8
    if !frame!==0 set "currentSpin=!Spin8!"
    if !frame!==1 set "currentSpin=!Spin1!"
    if !frame!==2 set "currentSpin=!Spin2!"
    if !frame!==3 set "currentSpin=!Spin3!"
    if !frame!==4 set "currentSpin=!Spin4!"
    if !frame!==5 set "currentSpin=!Spin5!"
    if !frame!==6 set "currentSpin=!Spin6!"
    if !frame!==7 set "currentSpin=!Spin7!"
    
    <nul set /p "=%ESC%[1A%ESC%[2K  !currentSpin! %Magenta%%msg%...%Reset%%ESC%[0E"
    timeout /t 0 /nobreak >nul 2>&1
)
<nul set /p "=%ESC%[1A%ESC%[2K"
exit /b

:ShowSuccessBar
set "width=%~1"
if "%width%"=="" set "width=50"
echo.
set "bar="
for /l %%i in (1,1,%width%) do (
    set "bar=!bar!#"
    <nul set /p "=%ESC%[1A%ESC%[2K  %BrightGreen%!bar!%Reset%%ESC%[0E"
    timeout /t 0 /nobreak >nul 2>&1
)
echo.
exit /b

:AnimatedOperation
set "opName=%~1"
set "command=%~2"
echo  %SymWork% %Magenta%%opName%...%Reset%
%command% >nul 2>&1
<nul set /p "=%ESC%[1A%ESC%[2K  %SymCheck% %Green%%opName%%Reset%%ESC%[0E"
echo.
exit /b

:PressAnyKey
echo  %Dim%Press any key to continue...%Reset%
pause >nul
exit /b